/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
 * dokument: gustaMatrica.cc
 * opis    : Definicija klase gustaMatrica
 *           gustaMatrica je najbrza konkretizacija matrice
 *           podaci su linearno smesteni u memoriju, matrica
 *           zauzima fiksni memorijski prostor koji se moze
 *           menjati samo eventualnim redimenzionisanjem iste.
 *           obezbedjene su sve potrebne metode, konstruktor,
 *           kopi konstruktor, destruktor, dodela, poredjenje,...
**/

#if !defined gustaMatrica_hh
#define gustaMatrica_hh

#include <iostream>
#include "matrica.hh"

using namespace std;

namespace jwork {

class gustaMatrica : public matrica {
  private:
    T *data;

  public:
    gustaMatrica(unsigned _sirina=1, unsigned _visina=1);
    gustaMatrica(const gustaMatrica &A);
    gustaMatrica & operator=(const gustaMatrica &A);
    ~gustaMatrica();

/////
    inline unsigned sizeOfT() { return sizeof(T); }
    inline unsigned sizeOfData() { return visina()*sirina(); }
    inline T *pointerOfData() { return data; }

    gustaMatrica(T *ddata, unsigned _sirina, unsigned _visina) : matrica(_sirina,_visina) {

  unsigned size=_sirina*_visina;
  data = new T[size];
  for (unsigned i=0;i<size;i++) 
    data[i]=ddata[i];
    
    }
/////

    // konkretizacija virtualnih metoda iz apstraktne klase matrica
    T get(unsigned x, unsigned y) const;
    void set(unsigned x, unsigned y, T broj);
    unsigned size() const;
    void nule();
    void postaviNovuMatricu(unsigned sirina, unsigned visina);

    // neki aritmeticki i poredbeni operatori
    gustaMatrica & operator += ( const gustaMatrica & B );
    gustaMatrica & operator -= ( const gustaMatrica & B );
    gustaMatrica & operator *= ( T faktor );
    gustaMatrica & operator /= ( T faktor );
    bool operator == ( const gustaMatrica & B ) const ;
    bool operator != ( const gustaMatrica & B ) const ;

};

} // namespace

#endif
