/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
 * dokument: gustaMatrica.cc
 * opis    : Definicija klase gustaMatrica
 *           gustaMatrica je najbrza konkretizacija matrice
 *           podaci su linearno smesteni u memoriju, matrica
 *           zauzima fiksni memorijski prostor koji se moze
 *           menjati samo eventualnim redimenzionisanjem iste.
 *           obezbedjene su sve potrebne metode, konstruktor,
 *           kopi konstruktor, destruktor, dodela, poredjenje,...
**/

#include <iostream>
#include "gustaMatrica.hh"

using namespace std;

namespace jwork {

gustaMatrica::gustaMatrica(unsigned sirina, unsigned visina) :
  matrica(sirina,visina) {
  data=new T[sirina*visina];
}

gustaMatrica::gustaMatrica(const gustaMatrica &A) : 
  matrica(A.sirina(),A.visina()) {
  unsigned sv=sirina()*visina();
  data=new T[sv];
  for (int i=sv-1;i>=0;i--)
    data[i]=A.data[i];
}

gustaMatrica & gustaMatrica::operator=(const gustaMatrica &A) {
  if (this != &A) {
    unsigned sv=A.sirina()*A.visina();
    if ( sirina()*visina() != sv ) {
      delete [] data;
      data=new T[sv];
    }
    promeni_dimenzije(A.sirina(),A.visina());
    for (int i=sv-1;i>=0;i--)
      data[i]=A.data[i];      
  }
  return *this;
}

gustaMatrica::~gustaMatrica() {
  delete [] data;
}

T gustaMatrica::get(unsigned x, unsigned y) const {
  if (x>=sirina() || y>=visina())
    throw LOS_INDEKS_MATRICE;

  broji_get();
  broji_add();
  broji_mul();

  return data[y*sirina()+x]; 
}

void gustaMatrica::set(unsigned x, unsigned y, T broj) {
  if (x>=sirina() || y>=visina())
    throw LOS_INDEKS_MATRICE;

  if (fabs(broj)<NULA)
    broj=0;

  broji_set();
  broji_add();
  broji_mul();

  data[y*sirina()+x] = broj;
}

unsigned gustaMatrica::size() const {
  return sirina()*visina()*sizeof(T)+sizeof(matrica);
}

void gustaMatrica::nule() {
  for (int i=sirina()*visina()-1;i>=0;i--)
    data[i]=0;
}

gustaMatrica & gustaMatrica::operator += ( const gustaMatrica & B ) {
  if (sirina()==B.sirina() && visina()==B.visina()) 
    for (int i(sirina()*visina()-1);i>=0;i--)
      data[i]+=B.data[i];
  else
    throw DIMENZIJE_SE_NE_PODUDARAJU;
  return *this;
}

gustaMatrica & gustaMatrica::operator -= ( const gustaMatrica & B ) {
  if (sirina()==B.sirina() && visina()==B.visina()) 
    for (int i(sirina()*visina()-1);i>=0;i--)
      data[i]-=B.data[i];
  else
    throw DIMENZIJE_SE_NE_PODUDARAJU;
  return *this;
}

gustaMatrica & gustaMatrica::operator *= ( T faktor ) {
  for (int i(sirina()*visina()-1);i>=0;i--)
    data[i]*=faktor;
}

gustaMatrica & gustaMatrica::operator /= ( T faktor ) {
  if (faktor==0) 
    throw DELJENJE_NULOM;
  for (int i(sirina()*visina()-1);i>=0;i--)
    data[i]/=faktor;
}

bool gustaMatrica::operator == ( const gustaMatrica & B ) const {
  bool ret = true;
  if (sirina()!=B.sirina() || visina()!=B.visina())
    ret = false;
  else
    for (int i(sirina()*visina()-1);i>=0;i--) {
      if (data[i]!=B.data[i]) {
        ret = false;
        break;
      }
    }
  return ret;
}

bool gustaMatrica::operator != ( const gustaMatrica & B ) const {
  return !operator==(B);
}

ostream & operator << ( ostream & ostr , const matrica & M ) {
  return M.ispisi(ostr);
}

void gustaMatrica::postaviNovuMatricu(unsigned sirina, unsigned visina) {
  delete [] data;
  data=new T[sirina*visina];
  promeni_dimenzije(sirina,visina);  
}

} // namespace

