class distrGustaMatrica : public gustaMatrica {
  private:
    unsigned prvaJednacina;
    unsigned n;
    unsigned m;
  public:
    distrGustaMatrica(unsigned prva=NEDEFINISANO , unsigned _s=0, unsigned _v=0) : gustaMatrica( _s, _v ) { prvaJednacina=prva; }   
    void MPI_Send(unsigned destination) const;
    void MPI_Recv(unsigned source);
    void MPI_Bcast(unsigned rank);

    inline void set_nm(unsigned _n, unsigned _m) { n=_n; m=_m; }
    inline unsigned nm() { return n*m; }
    inline unsigned get_n() { return n; };
    inline unsigned get_m() { return m; };

    inline unsigned prva() const { return prvaJednacina; }

    T normaRedova_A_zaJacobi();
};

T distrGustaMatrica::normaRedova_A_zaJacobi() {
  T max(0);
  for (unsigned j=0; j<visina(); j++) {
    T sum(0);
    for (unsigned i=0; i<n; i++)
      sum+=fabs(get(i,j));
    if (max<sum)
      max=sum;    
    if (max>1)
      break;
  }
  return max;
}

void distrGustaMatrica::MPI_Send( unsigned destination ) const {
  T data[sirina()*visina()];

  unsigned iter(0);
  for (unsigned j=0; j<visina(); j++)
    for (unsigned i=0; i<sirina(); i++)
      data[iter++]=get(i,j);
      
  unsigned info[5];
  info[0]=sirina();
  info[1]=visina();
  info[2]=prvaJednacina;
  info[3]=n;
  info[4]=m;
  
  MPI::COMM_WORLD.Send( info, 5, MPI::UNSIGNED, destination, 0);
  
//  cerr << "SALJEM " << iter*sizeof(T)/1024.00 << " KB"<< endl;
  
  MPI::COMM_WORLD.Send( data, iter, MPI_T, destination, 0 ); 
}

void distrGustaMatrica::MPI_Recv( unsigned source ) {

  unsigned info[5];

  MPI::COMM_WORLD.Recv( info, 5, MPI::UNSIGNED, source, 0 );

  unsigned sirina(info[0]);
  unsigned visina(info[1]);
  
  postaviNovuMatricu(sirina,visina);
  prvaJednacina=info[2];
  n=info[3];
  m=info[4];
  
  unsigned iter(0);
  T data[sirina*visina];
  
//  cerr << "PRIMAM " << sirina*visina*sizeof(T) << " BAJTOVA" << endl;

  MPI::COMM_WORLD.Recv( data, sirina*visina, MPI_T, source, 0 );
  
  for (unsigned j=0; j<visina; j++)
    for (unsigned i=0; i<sirina; i++) 
      set(i,j,data[iter++]);  
      
//  cerr << "PRIMIO " << sirina*visina*sizeof(T) << " BAJTOVA" << endl;     
}

void distrGustaMatrica::MPI_Bcast( unsigned rank ) {

  unsigned info[5];
  T *data;
  unsigned iter(0),vis,sir;

  if (rank==0) {
    data = new T[sirina()*visina()];
    for (unsigned j=0; j<visina(); j++)
      for (unsigned i=0; i<sirina(); i++)
        data[iter++]=get(i,j);      
    info[0]=sir=sirina();
    info[1]=vis=visina();
    info[2]=prvaJednacina;
    info[3]=n;
    info[4]=m;
  }
  
  MPI::COMM_WORLD.Bcast( info, 5, MPI::UNSIGNED,  0);  
  
  if (rank!=0) {
    sir=info[0];
    vis=info[1];
    prvaJednacina=info[2];
    n=info[3];
    m=info[4];
    data = new T[sir*vis];
  }

//  if (rank==0)
//    cerr << "BCAST(0) SALJEM " << iter*sizeof(T)/1024.00 << " KB"<< endl;  
//  else
//    cerr << "BCAST("<< rank<<") PRIMAM " << sir*vis*sizeof(T)/1024.00 << " KB"<< endl;
   
  MPI::COMM_WORLD.Bcast( data, sir*vis, MPI_T,  0 ); 
  
  if (rank!=0) {
    iter=0;
    postaviNovuMatricu(sir,vis);
    for (unsigned j=0; j<visina(); j++)
      for (unsigned i=0; i<sirina(); i++)
        set(i,j,data[iter++]);      
  }
  
  delete [] data;
}

unsigned ucitajRedoveMatrice(unsigned n, unsigned m, unsigned brojJednacina, distrGustaMatrica & A) {

  A.postaviNovuMatricu(n+m,brojJednacina); 
  char c;
  
  for (unsigned j=0; j<brojJednacina; j++) {
    T x;
    for (unsigned i=0; i<n; i++) {
      cin >> x;
      A.set(i,j,x);
    }    
    cin >> c;
    for (unsigned i=n; i<n+m; i++) {
      cin >> x;
      A.set(i,j,x);
    }
  }
}


